package easik.states;

import easik.sketch.path.SketchPath;

/**
 * States implementing this interface can accept paths. 
 * Use this interface whenever a state will be sent paths.
 * 
 * @author Rob Fletcher 2005
 * @author Kevin Green 2006
 * @version 2006-06-13 Kevin Green
 */
public interface PathAcceptingState {
	/**
	 * Hook used by states to transmit information about a path. 
	 * 
	 * @param path A SketchPath element.
	 */
	public void passPath( SketchPath path );
}
